// Copyright  2002 Charlie Poole. All rights reserved.
using System;
using EnvDTE;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace NUnit.Wizards
{
	/// <summary>
	/// Summary description for TestFixtureTypeForm.
	/// </summary>
	public class TestFixtureTypeForm : System.Windows.Forms.Form
	{
		#region Instance Variables

		/// <summary>
		/// The wizard that is running
		/// </summary>
		CSharpAddTestFixtureWiz wizard;

		/// <summary>
		/// The wizard's test generator, where the form
		/// saves info about what to generate.
		/// </summary>
		TestFixtureGenerator generator;
		
		/// <summary>
		/// Used in the load routine to see if initialization
		/// has already been performed when the form is reloaded.
		/// </summary>
		private bool initialLoad = true;

		/// <summary>
		/// The currently selected project
		/// </summary>
		private Project selectedProject;

		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.RadioButton radioButtonSpecific;
		private System.Windows.Forms.RadioButton radioButtonSamples;
		private System.Windows.Forms.RadioButton radioButtonEmpty;
		private System.Windows.Forms.Button helpButton;
		private System.Windows.Forms.Button backButton;
		private System.Windows.Forms.Button cancelButton;
		private System.Windows.Forms.Button nextButton;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.ComboBox projectComboBox;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.ComboBox classComboBox;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label fixtureNameLabel;
		private System.Windows.Forms.Label projectNameLabel;
		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion
		
		#region Construction and Disposal

		public TestFixtureTypeForm( CSharpAddTestFixtureWiz wizard ) : base( )
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			this.wizard = wizard;
			this.generator = wizard.Generator;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.classComboBox = new System.Windows.Forms.ComboBox();
			this.label3 = new System.Windows.Forms.Label();
			this.projectComboBox = new System.Windows.Forms.ComboBox();
			this.label2 = new System.Windows.Forms.Label();
			this.radioButtonEmpty = new System.Windows.Forms.RadioButton();
			this.radioButtonSamples = new System.Windows.Forms.RadioButton();
			this.radioButtonSpecific = new System.Windows.Forms.RadioButton();
			this.label1 = new System.Windows.Forms.Label();
			this.helpButton = new System.Windows.Forms.Button();
			this.backButton = new System.Windows.Forms.Button();
			this.cancelButton = new System.Windows.Forms.Button();
			this.nextButton = new System.Windows.Forms.Button();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.projectNameLabel = new System.Windows.Forms.Label();
			this.fixtureNameLabel = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.classComboBox,
																					this.label3,
																					this.projectComboBox,
																					this.label2,
																					this.radioButtonEmpty,
																					this.radioButtonSamples,
																					this.radioButtonSpecific});
			this.groupBox1.Location = new System.Drawing.Point(112, 144);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(392, 200);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			// 
			// classComboBox
			// 
			this.classComboBox.DisplayMember = "Name";
			this.classComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.classComboBox.Location = new System.Drawing.Point(112, 96);
			this.classComboBox.Name = "classComboBox";
			this.classComboBox.Size = new System.Drawing.Size(256, 24);
			this.classComboBox.Sorted = true;
			this.classComboBox.TabIndex = 7;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(48, 96);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(56, 16);
			this.label3.TabIndex = 6;
			this.label3.Text = "Class:";
			// 
			// projectComboBox
			// 
			this.projectComboBox.DisplayMember = "Name";
			this.projectComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.projectComboBox.Location = new System.Drawing.Point(112, 56);
			this.projectComboBox.Name = "projectComboBox";
			this.projectComboBox.Size = new System.Drawing.Size(256, 24);
			this.projectComboBox.TabIndex = 5;
			this.projectComboBox.SelectedIndexChanged += new System.EventHandler(this.projectComboBox_SelectedIndexChanged);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(48, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(48, 23);
			this.label2.TabIndex = 4;
			this.label2.Text = "Project:";
			// 
			// radioButtonEmpty
			// 
			this.radioButtonEmpty.Location = new System.Drawing.Point(24, 160);
			this.radioButtonEmpty.Name = "radioButtonEmpty";
			this.radioButtonEmpty.Size = new System.Drawing.Size(352, 32);
			this.radioButtonEmpty.TabIndex = 2;
			this.radioButtonEmpty.Text = "Create an empty TestFixture";
			// 
			// radioButtonSamples
			// 
			this.radioButtonSamples.Location = new System.Drawing.Point(24, 136);
			this.radioButtonSamples.Name = "radioButtonSamples";
			this.radioButtonSamples.Size = new System.Drawing.Size(360, 24);
			this.radioButtonSamples.TabIndex = 1;
			this.radioButtonSamples.Text = "Create a TestFixture with some sample tests";
			// 
			// radioButtonSpecific
			// 
			this.radioButtonSpecific.Location = new System.Drawing.Point(24, 24);
			this.radioButtonSpecific.Name = "radioButtonSpecific";
			this.radioButtonSpecific.Size = new System.Drawing.Size(352, 24);
			this.radioButtonSpecific.TabIndex = 0;
			this.radioButtonSpecific.Text = "Create a TestFixture for testing a specific class";
			this.radioButtonSpecific.CheckedChanged += new System.EventHandler(this.radioButtonSpecific_CheckedChanged);
			// 
			// label1
			// 
			this.label1.BackColor = System.Drawing.SystemColors.Control;
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.ForeColor = System.Drawing.SystemColors.ControlText;
			this.label1.Location = new System.Drawing.Point(40, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(464, 24);
			this.label1.TabIndex = 1;
			this.label1.Text = "Step 1 of 2: Test Generation";
			// 
			// helpButton
			// 
			this.helpButton.Location = new System.Drawing.Point(112, 376);
			this.helpButton.Name = "helpButton";
			this.helpButton.TabIndex = 3;
			this.helpButton.Text = "&Help";
			this.helpButton.Click += new System.EventHandler(this.helpButton_Click);
			// 
			// backButton
			// 
			this.backButton.Location = new System.Drawing.Point(240, 376);
			this.backButton.Name = "backButton";
			this.backButton.TabIndex = 4;
			this.backButton.Text = "<&Back";
			this.backButton.Click += new System.EventHandler(this.backButton_Click);
			// 
			// cancelButton
			// 
			this.cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cancelButton.Location = new System.Drawing.Point(432, 376);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.TabIndex = 6;
			this.cancelButton.Text = "Cancel";
			this.cancelButton.Click += new System.EventHandler(this.cancelButton_Click);
			// 
			// nextButton
			// 
			this.nextButton.Location = new System.Drawing.Point(320, 376);
			this.nextButton.Name = "nextButton";
			this.nextButton.TabIndex = 7;
			this.nextButton.Text = "&Next>";
			this.nextButton.Click += new System.EventHandler(this.nextButton_Click);
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.projectNameLabel,
																					this.fixtureNameLabel,
																					this.label5,
																					this.label4});
			this.groupBox2.Location = new System.Drawing.Point(112, 40);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(392, 96);
			this.groupBox2.TabIndex = 8;
			this.groupBox2.TabStop = false;
			// 
			// projectNameLabel
			// 
			this.projectNameLabel.Location = new System.Drawing.Point(120, 56);
			this.projectNameLabel.Name = "projectNameLabel";
			this.projectNameLabel.Size = new System.Drawing.Size(264, 16);
			this.projectNameLabel.TabIndex = 3;
			// 
			// fixtureNameLabel
			// 
			this.fixtureNameLabel.Location = new System.Drawing.Point(120, 24);
			this.fixtureNameLabel.Name = "fixtureNameLabel";
			this.fixtureNameLabel.Size = new System.Drawing.Size(264, 16);
			this.fixtureNameLabel.TabIndex = 2;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(32, 56);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(64, 16);
			this.label5.TabIndex = 1;
			this.label5.Text = "In Project:";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(32, 24);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(80, 16);
			this.label4.TabIndex = 0;
			this.label4.Text = "Creating:";
			// 
			// TestFixtureTypeForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(520, 416);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.groupBox2,
																		  this.nextButton,
																		  this.cancelButton,
																		  this.backButton,
																		  this.helpButton,
																		  this.label1,
																		  this.groupBox1});
			this.Name = "TestFixtureTypeForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "CSharp TestFixture Wizard";
			this.Load += new System.EventHandler(this.TestFixtureTypeForm_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Helper Methods

		/// <summary>
		/// Add projects from current solution to the combo box,
		/// eliminating any that don't contain testable classes.
		/// </summary>
		private void AddProjectsToCombo()
		{
			int targetProjectIndex = -1;
			foreach ( Project project in wizard.Solution.Projects )
			{
				if ( HasTestableClasses( project ) )
				{
					int index = projectComboBox.Items.Add( project );
					if ( project.Name == wizard.ProjectName )
						targetProjectIndex = index;
				}
			}

			if ( targetProjectIndex >= 0 )
				projectComboBox.SelectedIndex = targetProjectIndex;
			else if ( projectComboBox.Items.Count > 0 )
				projectComboBox.SelectedIndex = 0;
		}

		private void AddClassesToCombo( Project project )
		{
			classComboBox.Items.Clear();
			classComboBox.Text = "";

			if ( project != null )
				AddClassesToCombo( project.CodeModel.CodeElements );

			if ( classComboBox.Items.Count > 0 )
				classComboBox.SelectedIndex = 0;
		}

		private void AddClassesToCombo( CodeElements codeElements )
		{
			foreach( CodeElement elem in codeElements )
			{
				if ( IsTestableClass( elem ) )
				{
					CodeClass codeClass = (CodeClass) elem;
					classComboBox.Items.Add( codeClass );
					AddClassesToCombo( codeClass.Members );
				}
				else if( IsNamespace( elem ) )
				{
					CodeNamespace codeNamespace = (CodeNamespace)elem;
					AddClassesToCombo( codeNamespace.Members );
				}
			}
		}

		private bool HasTestableClasses( Project project )
		{
			try
			{
				return project.FileName != "" &&
					HasTestableClasses( project.CodeModel.CodeElements );
			}
			catch
			{
				// Ignore projects that throw an exception due
				// to language subsystem not being installed,
				// or being an unmodeled project type.
			}

			return false;
		}
		
		private bool HasTestableClasses( CodeElements codeElements )
		{
			foreach( CodeElement elem in codeElements )
			{
				if ( IsTestableClass( elem ) || HasTestableClasses( elem ) )
					return true;
			}

			return false;
		}

		private bool HasTestableClasses( CodeElement elem )
		{
			if ( !IsNamespace( elem ) )
				return false;

			CodeNamespace codeNamespace = (CodeNamespace) elem;
			return HasTestableClasses( codeNamespace.Members );
		}

		private bool IsTestableClass( CodeElement elem )
		{
			if ( !IsClass( elem) || !IsLocallyDefined( elem ) )
				return false;

			CodeClass codeClass = (CodeClass) elem;
			if ( codeClass.Access != vsCMAccess.vsCMAccessPublic )
				return false;

			foreach( CodeAttribute attribute in codeClass.Attributes )
				if ( attribute.Name == "TestFixture" )
					return false;

			return true;
		}

		private bool IsLocallyDefined( CodeElement elem )
		{
			return elem.InfoLocation == vsCMInfoLocation.vsCMInfoLocationProject;
		}

		private bool IsClass( CodeElement elem )
		{
			return elem.Kind == vsCMElement.vsCMElementClass;
		}

		private bool IsNamespace( CodeElement elem )
		{
			return elem.Kind == vsCMElement.vsCMElementNamespace;
		}

		#endregion

		#region UI Event Handlers

		/// <summary>
		/// On initial load, set up the fields values and fill
		/// the project combo box.
		/// </summary>
		private void TestFixtureTypeForm_Load(object sender, System.EventArgs e)
		{
			if ( initialLoad )
			{
				fixtureNameLabel.Text = wizard.ItemName;
				projectNameLabel.Text = wizard.ProjectName;

				radioButtonSpecific.Checked = true;
				AddProjectsToCombo();
				initialLoad = false;
			}
		}

		/// <summary>
		/// Help button was clicked, so show help info
		/// </summary>
		private void helpButton_Click(object sender, System.EventArgs e)
		{
			// ToDo: provide help
		}

		/// <summary>
		/// Back button was clicked so return the result
		/// </summary>
		private void backButton_Click(object sender, System.EventArgs e)
		{
			wizard.Result = wizardResult.wizardResultBackOut;
			this.Close();	
		}

		/// <summary>
		/// Cancel button was clicked, so return the result
		/// </summary>
		private void cancelButton_Click(object sender, System.EventArgs e)
		{
			wizard.Result = wizardResult.wizardResultCancel;
			this.Close();
		}

		/// <summary>
		/// Specific class button check state has changed. Enable
		/// or disable the two combo boxes accordingly.
		/// </summary>
		private void radioButtonSpecific_CheckedChanged(object sender, System.EventArgs e)
		{
			projectComboBox.Enabled = radioButtonSpecific.Checked;
			classComboBox.Enabled = radioButtonSpecific.Checked;
		}

		/// <summary>
		/// Next button was clicked, so update test generator
		/// with info from the form before returning.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void nextButton_Click(object sender, System.EventArgs e)
		{
			if( radioButtonSpecific.Checked )
				generator.FixtureType = TestFixtureType.ClassSpecificFixture;
			else if( radioButtonSamples.Checked )
				generator.FixtureType = TestFixtureType.SampleFixture;
			else
				generator.FixtureType = TestFixtureType.EmptyFixture;

			generator.TargetClass = (CodeClass)classComboBox.SelectedItem;

			wizard.Result = wizardResult.wizardResultSuccess;
			this.Close();
		}

		/// <summary>
		/// When the selected project changes, fill the class combo
		/// box with classes from that project.
		/// </summary>
		private void projectComboBox_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Project project = (Project) projectComboBox.SelectedItem;
			if ( project != selectedProject )
			{
				selectedProject = project;
				AddClassesToCombo( project );
			}
		}

		#endregion
	}
}
