// Copyright  2002 Charlie Poole. All rights reserved.
using System;
using EnvDTE;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace NUnit.Wizards
{
	/// <summary>
	/// Summary description for CSharpAddTestFixtureWiz
	/// </summary>
	[ProgId("CSharpAddTestFixtureWiz")]
	public class CSharpAddTestFixtureWiz : IDTWizard
	{
		private DTE appDTE;

		private string wizardType;

		private string projectName, itemName;
		private string localDirectory, installDirectory;

		private ProjectItems projectItems;

		private TestFixtureGenerator generator;

		private wizardResult result;

		public CSharpAddTestFixtureWiz()
		{
		}

		public string ProjectName
		{
			get { return projectName; }
		}

		public string ItemName
		{
			get { return itemName; }
		}

		public wizardResult Result
		{
			get { return result; }
			set { result = value; }
		}

		public TestFixtureGenerator Generator
		{
			get { return generator; }
		}

		public Solution Solution
		{
			get { return appDTE.Solution; }
		}

		public void Execute ( object application , int hwndOwner , ref object[] contextParams , ref object[] customParams , ref EnvDTE.wizardResult retval )
		{
			appDTE = (DTE) application;
			wizardType = (string) contextParams[0];
			
			if ( wizardType.ToUpper() != EnvDTE.Constants.vsWizardAddItem )
			{
				string msg = "Wizard was called incorrectly. CSharpAddTestFixtureWiz is designed to add items to a project.\n\n";
				msg = msg + "The .vsz and .vsdir files should be installed in the VC#\\CSharpProjectItems directory.";
				
				MessageBox.Show( msg, "CSharpAddTestFixtureWiz Error" );

				retval = wizardResult.wizardResultFailure;
				return;
			}

			projectName = (string) contextParams[1];
			projectItems = (ProjectItems)contextParams[2];
			localDirectory = (string) contextParams[3];
			itemName = (string) contextParams[4];
			installDirectory = (string) contextParams[5];

			generator = new TestFixtureGenerator( projectName, projectItems, localDirectory, itemName, installDirectory );

			int step = 0;
			int nsteps = 2;
			Form[] form = { new TestFixtureTypeForm( this ), 
							new TestFixtureOptionsForm( this ) };

			while ( step >=0 && step < nsteps )
			{
				form[step].ShowDialog();

				switch( result )
				{
					case wizardResult.wizardResultSuccess:
						++step;
						break;
					case wizardResult.wizardResultBackOut:
						--step;
						break;
					case wizardResult.wizardResultCancel:
					case wizardResult.wizardResultFailure:
					default:
						retval = result;
						return;
				}
			}

			if ( step > 0 )
				result = generator.Generate();

			retval = result;
		}
	}
}
